#ifndef OEM6X8_H_
#define OEM6X8_H_

#include <avr/eeprom.h> 

// Credit for most of these goes to MegaPirateOSD and Syberian!
// Changed a lot to save space and add my own characters.

#define CHAR_OFFSET 37
#define CHAR_LENGTH 54
#define CHAR_ARRAY_OFFSET CHAR_OFFSET*8
#define CHAR_ARRAY_LENGTH CHAR_LENGTH*8

#define CHAR_SPECIAL_LENGTH 10
#define CHAR_SPECIAL_ARRAY_LENGTH CHAR_SPECIAL_LENGTH*8
#define CHAR_SPECIAL_OFFSET 100

#if CHAR_LENGTH+CHAR_SPECIAL_LENGTH > 64
#error "Too many characters!"
#endif

static const uint8_t oem6x8[CHAR_ARRAY_LENGTH] EEMEM = { // 6x8 DOS character set
_XX__X__,
_XX__X__,
____X___,
___X____,
__X_____,
_X__XX__,
_X__XX__,
________,

__X_____, // Replace?
_X_X____,
_X_X____,
__X_____,
_X_X_X__,
_X__X___,
__XX_X__,
________,

__XX____, // Replace?
__XX____,
__X_____,
________,
________,
________,
________,
________,

___X____, // Replace?
__X_____,
__X_____,
__X_____,
__X_____,
__X_____,
___X____,
________,

__X_____, // Replace?
___X____,
___X____,
___X____,
___X____,
___X____,
__X_____,
________,

________, // Replace?
__X_X___,
__XXX___,
_XXXXX__,
__XXX___,
__X_X___,
________,
________,

________, // Replace?
___X____,
___X____,
_XXXXX__,
___X____,
___X____,
________,
________,

________,
________,
________,
________,
________,
__XX____,
__XX____,
__X_____,

________,
________,
________,
_XXXXX__,
________,
________,
________,
________,

________,
________,
________,
________,
________,
__XX____,
__XX____,
________,

________,
_____X__,
____X___,
___X____,
__X_____,
_X______,
________,
________,

__XXX___,
_X___X__,
_X__XX__,
_X_X_X__,
_XX__X__,
_X___X__,
__XXX___,
________,

___X____,
__XX____,
___X____,
___X____,
___X____,
___X____,
__XXX___,
________,

__XXX___,
_X___X__,
_____X__,
___XX___,
__X_____,
_X______,
_XXXXX__,
________,

__XXX___,
_X___X__,
_____X__,
__XXX___,
_____X__,
_X___X__,
__XXX___,
________,

____X___,
___XX___,
__X_X___,
_X__X___,
_XXXXX__,
____X___,
____X___,
________,

_XXXXX__,
_X______,
_X______,
_XXXX___,
_____X__,
_X___X__,
__XXX___,
________,

___XX___,
__X_____,
_X______,
_XXXX___,
_X___X__,
_X___X__,
__XXX___,
________,

_XXXXX__,
_____X__,
____X___,
___X____,
__X_____,
__X_____,
__X_____,
________,

__XXX___,
_X___X__,
_X___X__,
__XXX___,
_X___X__,
_X___X__,
__XXX___,
________,

__XXX___,
_X___X__,
_X___X__,
__XXXX__,
_____X__,
____X___,
__XX____,
________,

________,
________,
__XX____,
__XX____,
________,
__XX____,
__XX____,
________,

________, // Replace?
________,
__XX____,
__XX____,
________,
__XX____,
__XX____,
__X_____,

____X___, // Replace?
___X____,
__X_____,
_X______,
__X_____,
___X____,
____X___,
________,

________, // Replace?
________,
_XXXXX__,
________,
________,
_XXXXX__,
________,
________,

__X_____, // Replace?
___X____,
____X___,
_____X__,
____X___,
___X____,
__X_____,
________,

__XXX___,
_X___X__,
_____X__,
___XX___,
___X____,
________,
___X____,
________,

__XXX___, // Replace?
_X___X__,
_X_XXX__,
_X_X_X__,
_X_XXX__,
_X______,
__XXX___,
________,

__XXX___,
_X___X__,
_X___X__,
_X___X__,
_XXXXX__,
_X___X__,
_X___X__,
________,

_XXXX___,
_X___X__,
_X___X__,
_XXXX___,
_X___X__,
_X___X__,
_XXXX___,
________,

__XXX___,
_X___X__,
_X______,
_X______,
_X______,
_X___X__,
__XXX___,
________,

_XXXX___,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
_XXXX___,
________,

_XXXXX__,
_X______,
_X______,
_XXXX___,
_X______,
_X______,
_XXXXX__,
________,

_XXXXX__,
_X______,
_X______,
_XXXX___,
_X______,
_X______,
_X______,
________,

__XXX___,
_X___X__,
_X______,
_X_XXX__,
_X___X__,
_X___X__,
__XXXX__,
________,

_X___X__,
_X___X__,
_X___X__,
_XXXXX__,
_X___X__,
_X___X__,
_X___X__,
________,

__XXX___,
___X____,
___X____,
___X____,
___X____,
___X____,
__XXX___,
________,

_____X__,
_____X__,
_____X__,
_____X__,
_X___X__,
_X___X__,
__XXX___,
________,

_X___X__,
_X__X___,
_X_X____,
_XX_____,
_X_X____,
_X__X___,
_X___X__,
________,

_X______,
_X______,
_X______,
_X______,
_X______,
_X______,
_XXXXX__,
________,

_X___X__,
_XX_XX__,
_X_X_X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
________,

_X___X__,
_XX__X__,
_X_X_X__,
_X__XX__,
_X___X__,
_X___X__,
_X___X__,
________,

__XXX___,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
__XXX___,
________,

_XXXX___,
_X___X__,
_X___X__,
_XXXX___,
_X______,
_X______,
_X______,
________,

__XXX___,
_X___X__,
_X___X__,
_X___X__,
_X_X_X__,
_X__X___,
__XX_X__,
________,

_XXXX___,
_X___X__,
_X___X__,
_XXXX___,
_X__X___,
_X___X__,
_X___X__,
________,

__XXX___,
_X___X__,
_X______,
__XXX___,
_____X__,
_X___X__,
__XXX___,
________,

_XXXXX__,
___X____,
___X____,
___X____,
___X____,
___X____,
___X____,
________,

_X___X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
__XXX___,
________,

_X___X__,
_X___X__,
_X___X__,
_X___X__,
_X___X__,
__X_X___,
___X____,
________,

_X___X__,
_X___X__,
_X_X_X__,
_X_X_X__,
_X_X_X__,
_X_X_X__,
__X_X___,
________,

_X___X__,
_X___X__,
__X_X___,
___X____,
__X_X___,
_X___X__,
_X___X__,
________,

_X___X__,
_X___X__,
_X___X__,
__X_X___,
___X____,
___X____,
___X____,
________,

_XXXX___,
____X___,
___X____,
__X_____,
_X______,
_X______,
_XXXX___,
________,

};

#ifdef TEXT_USE_SPECIAL_CHARS
static const uint8_t specialChars[CHAR_SPECIAL_ARRAY_LENGTH] EEMEM = { // 6x8 special characters
___X____, // \144
__XXX___,
_XXXXX__,
___X____,
___X____,
___X____,
___X____,
________,

___X____, // \145
___X____,
___X____,
___X____,
_XXXXX__,
__XXX___,
___X____,
________,

___X____, // \146
__X_X___,
_X___X__,
X_____X_,
_X___X__,
_X_X_X__,
_XXXXX__,
________,

___X__X_, // \147
__X_XX__,
_X__XX__,
X__X__X_,
_XX__X__,
_X_X_X__,
XXXXXX__,
________,

X_______, // \150
X_______, //Credit to superjelli
_X___X__,
__X_X___,
__XX____,
__X__X__,
_XXX__X_,
_XXX____,

_XXXXX__, // \151
X_____X_,
__XXX___,
_X___X__,
___X____,
___X____,
___X____,
________,

0b00011000, // \152
0b00100100,
0b00100100,
0b00101100,
0b00111100,
0b00111100,
0b00111100,
0b00000000,

0b10000000, // \153 Remove?
0b10010000,
0b11101000,
0b00101010,
0b00010100,
0b00000010,
0b00000100,
0b00000000,

________, // \154
________,
________,
___X____,
___X____,
___X____,
___X____,
___X____,

________, // \155
________,
________,
________,
XXXXXXX_,
_XXXXX__,
__XXX___,
___X____,
};
#endif //TEXT_USE_SPECIAL_CHARS

/*
________,
________,
________,
________,
________,
________,
________,
________,
*/



#endif //OEM6X8_H_
